/*
 * Decompiled with CFR 0.152.
 */
package org.apache.fop.fo.flow;

import java.util.Stack;
import org.apache.fop.apps.FOPException;
import org.apache.fop.complexscripts.bidi.DelimitedTextRange;
import org.apache.fop.fo.FONode;
import org.apache.fop.fo.PropertyList;
import org.apache.fop.fo.flow.Inline;
import org.apache.fop.fo.properties.Property;

public class BidiOverride
extends Inline {
    private Property letterSpacing;
    private Property wordSpacing;
    private int direction;
    private int unicodeBidi;

    public BidiOverride(FONode parent) {
        super(parent);
    }

    @Override
    public void bind(PropertyList pList) throws FOPException {
        super.bind(pList);
        this.letterSpacing = pList.get(141);
        this.wordSpacing = pList.get(265);
        this.direction = pList.get(86).getEnum();
        this.unicodeBidi = pList.get(255).getEnum();
    }

    public Property getLetterSpacing() {
        return this.letterSpacing;
    }

    public Property getWordSpacing() {
        return this.wordSpacing;
    }

    public int getDirection() {
        return this.direction;
    }

    public int getUnicodeBidi() {
        return this.unicodeBidi;
    }

    @Override
    public String getLocalName() {
        return "bidi-override";
    }

    @Override
    public int getNameId() {
        return 2;
    }

    @Override
    protected Stack<DelimitedTextRange> collectDelimitedTextRanges(Stack<DelimitedTextRange> ranges, DelimitedTextRange currentRange) {
        char pfx = '\u0000';
        char sfx = '\u0000';
        int unicodeBidi = this.getUnicodeBidi();
        int direction = this.getDirection();
        if (unicodeBidi == 15) {
            pfx = direction == 122 ? (char)'\u202e' : '\u202d';
            sfx = '\u202c';
        } else if (unicodeBidi == 38) {
            pfx = direction == 122 ? (char)'\u202b' : '\u202a';
            sfx = '\u202c';
        }
        if (currentRange != null) {
            if (pfx != '\u0000') {
                currentRange.append(pfx, (FONode)this);
            }
            FONode.FONodeIterator it = this.getChildNodes();
            while (it != null && it.hasNext()) {
                ranges = ((FONode)it.next()).collectDelimitedTextRanges(ranges);
            }
            if (sfx != '\u0000') {
                currentRange.append(sfx, (FONode)this);
            }
        }
        return ranges;
    }
}

