<?xml version="1.0" encoding="utf-8"?>
<!--

 Copyright © 2009 Intel Corporation. All rights reserved.

 The information contained herein is the exclusive property of
 Intel Corporation and may not be disclosed, examined, or reproduced in
 whole or in part without explicit written authorization from the Company.

-->
<xsl:stylesheet version="1.0"
                xmlns:xsl="http://www.w3.org/1999/XSL/Transform"
                xmlns:msxsl="urn:schemas-microsoft-com:xslt"
                xmlns:exsl="http://exslt.org/common"
                exclude-result-prefixes="msxsl"
                xmlns:int="http://www.w3.org/2001/XMLSchema#int"
                xmlns:boolean="http://www.w3.org/2001/XMLSchema#boolean"
                xmlns:str="http://exslt.org/strings"
                xmlns:fnc="urn:functions">
  <xsl:import href="config://include/gpu_common_functions.inc"/>
  <xsl:output indent="yes" method="xml"/>
  <xsl:param name="id">summaryPane</xsl:param>
  <xsl:param name="contextMode">false</xsl:param>
  <xsl:param name="displayName">SummaryWindow</xsl:param>
  <xsl:param name="description">HotspotsSummaryWindowDescription</xsl:param>
  <xsl:param name="resultSummaryHeaderColumn">TotalElapsedTime</xsl:param>
  <xsl:param name="resultSummaryColumns">MySummaryColumns</xsl:param>
  <xsl:param name="helpKeyWord">configs.interpret_result_summary_f1024</xsl:param>
  <xsl:param name="querySuffix"/>
  <xsl:param name="showBandwidth">false</xsl:param>
  <xsl:param name="summaryInfoMaxLevelsToShow">100</xsl:param>
  <xsl:param name="manageGlobalFilter">false</xsl:param>
  <xsl:param name="showHottestTasks">true</xsl:param>
  <xsl:param name="showBandwidthUtilization">false</xsl:param>
  <xsl:param name="showPhysicalCores">false</xsl:param>
  <xsl:param name="showGPUUsage">true</xsl:param>
  <xsl:param name="showHostUsage">false</xsl:param>
  <xsl:param name="showEUArrayMetrics">true</xsl:param>
  <xsl:param name="packetsType">true</xsl:param>
  <xsl:param name="showFpuUtilization">true</xsl:param>
  <xsl:param name="showStalledIdle">true</xsl:param>
  <xsl:param name="showComputeTransfer">false</xsl:param>
  <xsl:param name="showGPUSummaryInfo">true</xsl:param>
  <xsl:param name="cpuGpuInteration">false</xsl:param>
  <xsl:param name="inKernelProfiling">false</xsl:param>
  <xsl:param name="showCPUHotspots">false</xsl:param>
  <xsl:param name="showCPUUsage">false</xsl:param>
  <xsl:param name="showAcceleratorOCL">false</xsl:param>
  <xsl:param name="showUtube">false</xsl:param>
  <xsl:param name="enableLinksInSummaryInfo">true</xsl:param>
  <xsl:param name="showResultInfo">true</xsl:param>
  <xsl:param name="highlightColumnsWithExpansion">true</xsl:param>
  <xsl:param name="applicationFile">summary</xsl:param>
  <xsl:param name="FPGAisVPU">false</xsl:param>
  <xsl:param name="showFrames">
    <xsl:value-of select="exsl:is_non_empty_table_exist('frame_data')"/>
  </xsl:param>
<xsl:template match="/">
    <xsl:variable name="gpuTilePrefix" select="exsl:ctx('gpuDisplayPrefix', 'GPU')"/>
    <xsl:variable name="gpuOpenCLDataCollected" select="exsl:is_non_empty_table_exist('gpu_compute_task_data')"/>
    <xsl:variable name="gpuDataCollected" select="exsl:is_non_empty_table_exist('gpu_data') or exsl:is_non_empty_table_exist('gpu_freq_data') or exsl:is_non_empty_table_exist('dma_packet_data') or $gpuOpenCLDataCollected"/>
    <xsl:variable name="isGPUPeakOccupancyApplicable" select="$gpuOpenCLDataCollected and not(fnc:is_multi_gpu_adapter_system()) and exsl:ctx('gpuEuCoresPerSubsliceCount', 0) > 1 and exsl:ctx('gpuEuCount', 0) > 1 and exsl:ctx('gpuMaxEuThreadCount', 0) > 1"/>
    <xsl:variable name="barrierDataCollected" select="exsl:is_non_empty_table_exist('barrier_data')"/>
    <xsl:variable name="needToShowFrames" select="($showFrames='true') and exsl:is_non_empty_table_exist('frame_data')"/>
    <xsl:variable name="preciseClockticsCollected" select="exsl:ctx('collectPreciseClockticks')"/>
    <xsl:variable name="summaryBlocksParams">
      <params
        querySuffix="{$querySuffix}"
        contextMode="{$contextMode}"
        packetsType="{$packetsType}"
        showHottestTasks="$showHottestTasks"
        inKernelProfiling="$inKernelProfiling"
        cpuGpuInteration="{$cpuGpuInteration}"
          />
    </xsl:variable>
    <xsl:variable name="summaryBlocksFileName">
      <xsl:text>config://viewpoint/include/summaryblocks.xsl?</xsl:text>
      <xsl:for-each select="exsl:node-set($summaryBlocksParams)//@*">
        <xsl:if test=". and .!=''">
          <xsl:value-of select="concat(name(), '=', .)"/>
          <xsl:text>&amp;</xsl:text>
        </xsl:if>
      </xsl:for-each>
    </xsl:variable>
    <xsl:variable name="summaryBlocks" select="document($summaryBlocksFileName)"/>
    <html id="{$id}" displayName="%{$displayName}">
      <filter>
        <xsl:if test="$contextMode='true'">
          <xsl:attribute name="handleList">
            <xsl:text>global</xsl:text>
          </xsl:attribute>
        </xsl:if>
	      <xsl:attribute name="boolean:manageGlobalFilter">
          <xsl:value-of select="$manageGlobalFilter"/>
        </xsl:attribute>
      </filter>
      <event handleList="KnobChangedEvent"/>
      <application name="summary"/>
      <helpKeywordF1>
          <xsl:value-of select="$helpKeyWord"/>
      </helpKeywordF1>
      <description>
        <xsl:text>%</xsl:text>
        <xsl:value-of select="$description"/>
      </description>
      <icon file="client.dat#zip:images.xrc" image="tab_summary"/>
      <config>
        <xsl:if test="$contextMode='true'">
          <style>context-summary</style>
        </xsl:if>
        <xsl:if test="($contextMode != 'true')">
          <recommendations>
            <recommendation>
              <header>
                <column>/GpuBottomUpRecommendation</column>
              </header>
            </recommendation>
            <recommendation>
              <header>
                <column>/GpuNotActiveKernelRecommendation</column>
              </header>
            </recommendation>
            <recommendation>
              <header>
                <column>/GpuOccupancyKernelRecommendation</column>
              </header>
            </recommendation>
            <recommendation>
              <header>
                <column>/GpuThreadCountKernelRecommendation</column>
              </header>
            </recommendation>
            <recommendation>
              <header>
                <column>/GpuThreadRateKernelRecommendation</column>
              </header>
            </recommendation>
            <xsl:if test="not(exsl:IsNonEmptyTableExist('gpu_compute_task_data')) and fnc:is_multi_gpu_adapter_system() and contains(exsl:ctx('collectGpuOpenCl', ''), 'true')">
              <recommendation>
                <header>
                  <column>/GpuMultiAdapterWarning</column>
                </header>
              </recommendation>
              <xsl:if test="not(exsl:IsNonEmptyTableExist('gpu_compute_task_data')) and not(exsl:IsNonEmptyTableExist('draw_call_data')) and contains(exsl:ctx('collectGpuOpenCl', ''), 'true')">
                <recommendation>
                  <header>
                    <column>/GpuNoAPITraceDataWarning</column>
                  </header>
                </recommendation>
              </xsl:if>
            </xsl:if>
          </recommendations>
        </xsl:if>
        <sections>
          <xsl:if test="$showGPUSummaryInfo='true'">
            <section>
              <header>
                <xsl:choose>
                  <xsl:when test="$contextMode='true'">
                    <column>/GPUElapsedTime</column>
                  </xsl:when>
                  <xsl:otherwise>
                    <column>/TotalElapsedTime</column>
                  </xsl:otherwise>
                </xsl:choose>
              </header>
              <xsl:if test="($contextMode != 'true') and exsl:ctx('allowMultipleRuns', 0)">
                <description displayName="%TotalElapsedTimeMultirunNote"/>
              </xsl:if>
              <sections>
                <xsl:if test="$cpuGpuInteration='true' and $showGPUUsage='true'">
                  <xsl:copy-of select="$summaryBlocks//root/gpuEnginesUsage/*"/>
                </xsl:if>
                <xsl:if test="$inKernelProfiling='true'">
                  <section expanded="onIssues">
                    <header>
                      <column>/GPUGpuTime</column>
                    </header>
                  </section>
                </xsl:if>
                <xsl:copy-of select="$summaryBlocks//root/npuUsage/*"/>
              </sections>
            </section>
          </xsl:if>
          <xsl:copy-of select="$summaryBlocks//root/CCLTasks/*"/>
          <xsl:if test="exsl:is_non_empty_table_exist('dd_gpu_node') and fnc:is_multi_gpu_tile_system() and (contains(exsl:ctx('gpuMetricsSelected', ''), 'STACK_TO_STACK') or exsl:is_non_empty_table_exist('fabric_traffic_data'))">
            <xsl:copy-of select="$summaryBlocks//root/platformDiagramWithGPU/*"/>
          </xsl:if>
          <xsl:if test="exsl:is_non_empty_table_exist('fabric_traffic_data')">
            <xsl:copy-of select="$summaryBlocks//root/xelinkUsage/*"/>
          </xsl:if>
          <xsl:if test="$showHostUsage='true'">
            <xsl:copy-of select="$summaryBlocks//root/hostUsage/*"/>
          </xsl:if>
          <xsl:variable name="multiGpuGrouping" select="fnc:get_multi_gpu_grouping()"/>
          <xsl:if test="$contextMode='false' and exsl:is_non_empty_table_exist('gpu_gtpin_data')">
            <section type="grid" expanded="true" nullValue="hide">
              <header displayName="%TopGPUDeepProfilingHotspots"/>
              <description displayName="%TopGPUDeepProfilingHotspotsDescription" />
              <grid limit="5">
                <columns>
                  <column>/GPUGTPinComputeTaskTimeSummary</column>
                  <column>/GPUGTPinComputeTaskDurationSummary</column>
                  <column>/GPUGTPinComputeTaskCountSummary</column>
                  <column>/GPUGTPinInstLatency</column>
                  <column>/GPUGTPinInstructionCount</column>
                  <column>/GPUGTPinMaaInstructionCount</column>
                </columns>
                <sorting>/GPUGTPinComputeTaskTimeSummary</sorting>
                <grouping>/GPUHotspotsComputeTaskTypeVector</grouping>
                <href>
                  <activate tabId="gpuTimelinePane" handlerId="bottomUpPane">
                    <xsl:choose>
                      <xsl:when test="(exsl:ctx('appRunsCount', 1) > 1)">
                        <grouping><xsl:value-of select="$multiGpuGrouping"/><xsl:text>/GPUHotspotsComputeTaskTypeVector</xsl:text></grouping>
                      </xsl:when>
                      <xsl:otherwise>
                        <grouping><xsl:value-of select="$multiGpuGrouping"/><xsl:text>/GPUHotspotsComputeTaskTypeVector/GPUFunctionVector/GPUParentCallStackVector</xsl:text></grouping>
                      </xsl:otherwise>
                    </xsl:choose>
                    <row/>
                  </activate>
                </href>
              </grid>
            </section>
          </xsl:if>
          <xsl:if test="$contextMode='false' and exsl:is_non_empty_table_exist('gpu_sampling_data')">
            <section type="grid" expanded="true" nullValue="hide">
              <header displayName="%TopGPUDeepProfilingHotspots"/>
              <description displayName="%TopGPUDeepProfilingHotspotsDescription" />
              <grid limit="5">
                <columns>
                  <column>/GPUSamplingComputeTaskTimeSummary</column>
                  <column>/GPUSamplingComputeTaskDurationSummary</column>
                  <column>/GPUSamplingComputeTaskCountSummary</column>
                  <column>/GPUSamplingControlEventCountSummary</column>
                  <column>/GPUSamplingDistOrAccEventCountSummary</column>
                  <column>/GPUSamplingInstFetchEventCountSummary</column>
                  <column>/GPUSamplingPipeEventCountSummary</column>
                  <column>/GPUSamplingSbidEventCountSummary</column>
                  <column>/GPUSamplingSendEventCountSummary</column>
                  <column>/GPUSamplingSyncEventCountSummary</column>
                  <column>/GPUSamplingTdrEventCountSummary</column>
                  <column>/GPUSamplingOtherEventCountSummary</column>
                </columns>
                <sorting>/GPUSamplingComputeTaskTimeSummary</sorting>
                <grouping>/GPUHotspotsComputeTaskTypeVector</grouping>
                <href>
                  <activate tabId="gpuTimelinePane" handlerId="bottomUpPane">
                    <xsl:choose>
                      <xsl:when test="(exsl:ctx('appRunsCount', 1) > 1)">
                        <grouping><xsl:value-of select="$multiGpuGrouping"/><xsl:text>/GPUHotspotsComputeTaskTypeVector</xsl:text></grouping>
                      </xsl:when>
                      <xsl:otherwise>
                       <grouping><xsl:value-of select="$multiGpuGrouping"/><xsl:text>/GPUHotspotsComputeTaskTypeVector/GPUFunctionVector/GPUParentCallStackVector</xsl:text></grouping>
                      </xsl:otherwise>
                    </xsl:choose>
                    <row/>
                  </activate>
                </href>
              </grid>
            </section>
          </xsl:if>
          <xsl:if test="$cpuGpuInteration='false' and $inKernelProfiling='false'">
            <xsl:if test="$showGPUUsage='true'">
              <xsl:copy-of select="$summaryBlocks//root/gpuEnginesUsage/*"/>
            </xsl:if>
          </xsl:if>
          <xsl:choose>
            <xsl:when test="(exsl:is_non_empty_table_exist('conditional_gpu_data')
              and exsl:is_non_empty_table_exist('gpu_data'))
              or (exsl:ctx('gsimClockDuration', 0) > 0)">
              <xsl:variable name="gpuAdapterTileNameList">
                <xsl:choose>
                  <xsl:when test="exsl:ctx('gpuAdapterTileNameList', '') != ''">
                    <xsl:value-of select="exsl:ctx('gpuAdapterTileNameList', '')"/>
                  </xsl:when>
                  <xsl:otherwise>
                    <xsl:choose>
                      <xsl:when test="exsl:ctx('gpuAdapterNameList', '') != ''">
                        <xsl:value-of select="exsl:ctx('gpuAdapterNameList', '')"/>
                      </xsl:when>
                      <xsl:otherwise>
                        <![CDATA[GPU Adapter]]>
                      </xsl:otherwise>
                    </xsl:choose>
                  </xsl:otherwise>
                </xsl:choose>
              </xsl:variable>
              <xsl:if test="$showStalledIdle='true' or $showFpuUtilization='true'">
                <xsl:choose>
                  <xsl:when test="contains(exsl:group_adapters_by_device_id(), ',')">
                    <xsl:for-each select="str:split(exsl:group_adapters_by_device_id(), ';')">
                        <xsl:variable name="deviceGroup" select="str:split(., '|')"/>
                        <xsl:variable name="groupId" select="$deviceGroup[1]"/>
                        <xsl:variable name="devices" select="str:split($deviceGroup[2], ',')"/>
                        <xsl:variable name="deviceName" select="str:replace(str:replace(str:replace(substring-after(string($devices[1]), ': '), ' ', '%20'), '[', '%5B'), ']', '%5D')"/>
                        <xsl:variable name ="summaryBlocksAdapterParams">
                            <xsl:value-of select="concat('config://viewpoint/include/summaryblocks.xsl?', 'deviceName=', $deviceName, '&amp;groupId=', $groupId)"/>
                        </xsl:variable>
                        <xsl:variable name="summaryBlocksForAdapter" select="document($summaryBlocksAdapterParams)"/>
                        <xsl:copy-of select="$summaryBlocksForAdapter//root/gpuAdapterGroupMetrics/*"/>
                    </xsl:for-each>
                  </xsl:when>
                  <xsl:otherwise>
                      <xsl:for-each select="str:split($gpuAdapterTileNameList, ';')">
                      <xsl:variable name="adapterId" select="position()"/>
                      <xsl:variable name="gpuInfo" select="str:split(., '|')"/>
                        <xsl:variable name ="gpuAdapterGrouping">
                          <xsl:if test="fnc:is_multi_gpu_adapter_system()">
                            <xsl:value-of select="concat('/GPUAdapter[', $gpuInfo[1], ' : ', str:replace($gpuInfo[2], '/', '\/'), ']')"/>
                          </xsl:if>
                        </xsl:variable>
                        <xsl:variable name ="gpuAdapterGroupingName">
                          <xsl:choose>
                            <xsl:when test="count($gpuInfo) = 1">
                              <xsl:value-of select="$gpuInfo[1]"/>
                            </xsl:when>
                            <xsl:otherwise>
                              <xsl:value-of select="exsl:get_adapter_alias_by_name(concat($gpuInfo[1], ' : ', $gpuInfo[2]))"/>
                            </xsl:otherwise>
                          </xsl:choose>
                        </xsl:variable>
                        <xsl:variable name="tiles">
                          <xsl:choose>
                            <xsl:when test="count($gpuInfo) = 3">
                              <xsl:value-of select="$gpuInfo[3]"/>
                            </xsl:when>
                            <xsl:otherwise>0,</xsl:otherwise>
                          </xsl:choose>
                        </xsl:variable>
                        <xsl:variable name="gpuTiles" select="str:split($tiles, ',')"/>
                        <xsl:variable name="gpuTilesCount" select="count($gpuTiles)"/>
                        <xsl:choose>
                          <xsl:when test="fnc:is_multi_gpu_adapter_system()">
                            <xsl:variable name="gpuInfoBdfWithNone" select="concat($gpuInfo[1], '|', 'none')"/>
                            <xsl:if test="(not(contains(exsl:ctx('gpuCounters', ''), $gpuInfoBdfWithNone)) and contains(exsl:ctx('gpuCounters', ''), $gpuInfo[1]))
                                          or not(contains(exsl:ctx('gpuCounters', ''), '|'))
                                          or contains(exsl:ctx('gpuMetricsSelected', ''),$gpuInfo[1])">
                            <section expanded="true">
                              <header>
                                <xsl:attribute name="displayName"><xsl:value-of select="$gpuAdapterGroupingName"/></xsl:attribute>
                              </header>
                              <sections>
                                <xsl:for-each select="exsl:node-set($gpuTiles)">
                                  <xsl:variable name="tileId" select="current()"/>
                                  <xsl:variable name="notLocalizedName" select="concat('%', $gpuTilePrefix, 'TileName')"/>
                                  <xsl:variable name="tileName" select="exsl:message('viewpoint', $notLocalizedName, string($tileId))"/>
                                  <xsl:variable name ="summaryBlocksAdapterParams">
                                    <xsl:value-of select="concat('config://viewpoint/include/summaryblocks.xsl?', 'adapterId=', $adapterId, '&amp;tileId=', $tileId)"/>
                                  </xsl:variable>
                                  <xsl:variable name="summaryBlocksForAdapter" select="document($summaryBlocksAdapterParams)"/>
                                  <xsl:choose>
                                    <xsl:when test="$gpuTilesCount > 1">
                                      <section expanded="true">
                                        <header>
                                          <xsl:attribute name="displayName"><xsl:value-of select="$tileName"/></xsl:attribute>
                                        </header>
                                        <sections>
                                          <xsl:if test="$showStalledIdle='true'">
                                            <xsl:copy-of select="$summaryBlocksForAdapter//root/gpuStalledIdle/*"/>
                                          </xsl:if>
                                          <xsl:if test="$showFpuUtilization='true'">
                                            <xsl:copy-of select="$summaryBlocksForAdapter//root/gpuFpuUtilization/*"/>
                                          </xsl:if>
                                        </sections>
                                      </section>
                                    </xsl:when>
                                    <xsl:otherwise>
                                      <xsl:if test="$showStalledIdle='true'">
                                        <xsl:copy-of select="$summaryBlocksForAdapter//root/gpuStalledIdle/*"/>
                                      </xsl:if>
                                      <xsl:if test="$showFpuUtilization='true'">
                                        <xsl:copy-of select="$summaryBlocksForAdapter//root/gpuFpuUtilization/*"/>
                                      </xsl:if>
                                    </xsl:otherwise>
                                  </xsl:choose>
                                </xsl:for-each>
                              </sections>
                            </section>
                            </xsl:if>
                          </xsl:when>
                          <xsl:otherwise>
                            <xsl:for-each select="exsl:node-set($gpuTiles)">
                              <xsl:variable name="tileId" select="current()"/>
                              <xsl:variable name="notLocalizedName" select="concat('%', $gpuTilePrefix, 'TileName')"/>
                              <xsl:variable name="tileName" select="exsl:message('viewpoint', $notLocalizedName, string($tileId))"/>
                              <xsl:variable name ="summaryBlocksAdapterParams">
                                <xsl:value-of select="concat('config://viewpoint/include/summaryblocks.xsl?', 'adapterId=', $adapterId, '&amp;tileId=', $tileId)"/>
                              </xsl:variable>
                              <xsl:variable name="summaryBlocksForAdapter" select="document($summaryBlocksAdapterParams)"/>
                              <xsl:choose>
                                <xsl:when test="$gpuTilesCount > 1">
                                  <section expanded="true">
                                    <header>
                                      <xsl:attribute name="displayName"><xsl:value-of select="$tileName"/></xsl:attribute>
                                    </header>
                                    <sections>
                                      <xsl:if test="$showStalledIdle='true'">
                                        <xsl:copy-of select="$summaryBlocksForAdapter//root/gpuStalledIdle/*"/>
                                      </xsl:if>
                                      <xsl:if test="$showFpuUtilization='true'">
                                        <xsl:copy-of select="$summaryBlocksForAdapter//root/gpuFpuUtilization/*"/>
                                      </xsl:if>
                                    </sections>
                                  </section>
                                </xsl:when>
                                <xsl:otherwise>
                                  <xsl:if test="$showStalledIdle='true'">
                                    <xsl:copy-of select="$summaryBlocksForAdapter//root/gpuStalledIdle/*"/>
                                  </xsl:if>
                                  <xsl:if test="$showFpuUtilization='true'">
                                    <xsl:copy-of select="$summaryBlocksForAdapter//root/gpuFpuUtilization/*"/>
                                  </xsl:if>
                                </xsl:otherwise>
                              </xsl:choose>
                            </xsl:for-each>
                          </xsl:otherwise>
                        </xsl:choose>
                    </xsl:for-each>
                  </xsl:otherwise>
                </xsl:choose>
              </xsl:if>
            </xsl:when>
            <xsl:otherwise>
              <xsl:if test="$showEUArrayMetrics='true'">
                <xsl:copy-of select="$summaryBlocks//root/gpuEUArrayMetrics/*"/>
              </xsl:if>
            </xsl:otherwise>
          </xsl:choose>
          <xsl:if test="$showComputeTransfer='true' and $contextMode='false' ">
            <section type="grid" expanded="true">
              <header displayName="%TopGPUHotspots"/>
              <description displayName="%TopGPUHotspotsDescription"/>
              <grid limit="5" useCommonLimit="true">
                <columns>
                  <column>/GPUComputeTaskTimeSummary</column>
                  <column>/GPUComputeTaskCountSummary</column>
                  <xsl:if test="$isGPUPeakOccupancyApplicable">
                    <column>/GPUPeakOccupancyBaseSummary</column>
                  </xsl:if>
                  <xsl:if test="not(fnc:is_multi_gpu_adapter_system())">
                    <column>/GPUEuThreadOccupancy</column>
                    <column>/GPUThreadsPerWorkGroupRatio</column>
                  </xsl:if>
                </columns>
                <sorting>/GPUComputeTaskTimeSummary</sorting>
                <xsl:choose>
                  <xsl:when test="exsl:is_non_empty_table_exist('gpu_data')">
                    <grouping>/GPUComputeTaskTypeWithIssues</grouping>
                  </xsl:when>
                  <xsl:otherwise>
                    <grouping>/GPUComputeTaskTypeVector</grouping>
                  </xsl:otherwise>
                </xsl:choose>
                <xsl:if test="$isGPUPeakOccupancyApplicable">
                  <metricPassports>
                    <metricPassport sorting="ascending">
                      <column>/GPUPeakOccupancyBaseSummary</column>
                      <additionalData>
                        <column>/GPUPeakSLMOccupancyWhenLowOccupancyParameterized</column>
                        <formatter>ratio</formatter>
                      </additionalData>
                      <additionalData>
                        <column>/GPUPeakBarrierOccupancyWhenLowOccupancyParameterized</column>
                        <formatter>ratio</formatter>
                      </additionalData>
                      <additionalData>
                        <column>/GPUPeakActiveThreadsRatioWhenLowOccupancyParameterized</column>
                        <formatter>ratio</formatter>
                      </additionalData>
                      <threshold>/GPUPeakOccupancyThreshold</threshold>
                      <minIsBetter>false</minIsBetter>
                      <issue>/GPUPeakOccupancyIssues</issue>
                    </metricPassport>
                    <metricPassport>
                      <column>/GPUEuThreadOccupancy</column>
                      <threshold>/GPUOccupancyThresholdSummary</threshold>
                      <minIsBetter>false</minIsBetter>
                      <issue>%GPUThreadOccupancyWhenBusyIssueInKernelText</issue>
                    </metricPassport>
                  </metricPassports>
                </xsl:if>
                <href>
                  <activate tabId="gpuTimelinePane" handlerId="bottomUpPane">
                    <xsl:choose>
                      <xsl:when test="(exsl:ctx('appRunsCount', 1) > 1)">
                        <grouping>/GPUComputeTaskTypeVector</grouping>
                      </xsl:when>
                      <xsl:otherwise>
                        <grouping>/GPUComputeTaskTypeVector/GPUComputeTaskInstance</grouping>
                      </xsl:otherwise>
                    </xsl:choose>
                    <row/>
                  </activate>
                </href>
              </grid>
            </section>
          </xsl:if>
          <xsl:if test="$showBandwidthUtilization='true'">
            <xsl:copy-of select="$summaryBlocks//root/bandwidthUtilizationChart/*"/>
			      <xsl:copy-of select="$summaryBlocks//root/bandwidthUtilizationStatistic/*"/>
          </xsl:if>
          <xsl:if test="$contextMode='false'">
            <xsl:if test="exsl:is_non_empty_table_exist('discrete_graphics_power_data')">
              <xsl:copy-of select="$summaryBlocks//root/energyConsumption/*"/>
            </xsl:if>
            <xsl:if test="exsl:is_non_empty_table_exist('discrete_graphics_hbm_bandwidth_data') and exsl:is_non_empty_table_exist('discrete_graphics_cross_tile_hops_data')">
              <xsl:copy-of select="$summaryBlocks//root/dgfxHBMBandwidth/*"/>
              <xsl:copy-of select="$summaryBlocks//root/dgfxMDFBandwidth/*"/>
            </xsl:if>
          </xsl:if>
		      <xsl:if test="$FPGAisVPU='true'">
            <xsl:copy-of select="$summaryBlocks//root/vpuLoad/*"/>
          </xsl:if>
		      <xsl:if test="$showCPUHotspots='true'">
            <xsl:copy-of select="$summaryBlocks//root/cpuHotspots/*"/>
          </xsl:if>
		      <xsl:if test="$FPGAisVPU='true'">
            <xsl:copy-of select="$summaryBlocks//root/vpuToptasks/*"/>
          </xsl:if>
		      <xsl:if test="$showAcceleratorOCL='true'">
            <xsl:copy-of select="$summaryBlocks//root/acceleratorOCL/*"/>
          </xsl:if>
		      <xsl:if test="$showCPUUsage='true'">
            <xsl:copy-of select="$summaryBlocks//root/cpuUsageChart/*"/>
          </xsl:if>
		      <xsl:if test="$showBandwidth='true'">
            <xsl:copy-of select="$summaryBlocks//root/averageBandwidth/*"/>
          </xsl:if>
		      <xsl:if test="$needToShowFrames">
            <xsl:copy-of select="$summaryBlocks//root/frameChart/*"/>
          </xsl:if>
		      <xsl:if test="$contextMode='false'">
		        <section type="tree" nullValue="hide" expanded="false">
              <header displayName="%ResultInfo" />
              <description displayName="%ResultInfoDescription" />
              <tree valueAlign="left">
                <columns>
                  <column>/ResultInfo</column>
                </columns>
              </tree>
              <sections>
                <section type="tree" expanded="true" valueAlign="left">
                  <header displayName="%CPU" />
                  <tree valueAlign="left">
                    <columns>
                      <column>/CPUInfo</column>
                      <xsl:if test="$showPhysicalCores='true'">
                        <column>/PhysicalCoreCount</column>
                      </xsl:if>
                    </columns>
                  </tree>
                </section>
                <xsl:if test="$gpuDataCollected='true'">
                  <xsl:choose>
                    <xsl:when test="count(str:split(exsl:ctx('gpuCounters', ''), ',')) > 1">
                      <section expanded="true" valueAlign="left">
                        <header displayName="%GPU" />
                        <sections>
                          <xsl:for-each select="str:split(exsl:get_gpu_adapter_aliases_list(), ';')">
                            <xsl:variable name="currentGPUAlias" select="."/>
                            <xsl:variable name="currentGPUName" select="exsl:get_adapter_name_by_alias(string($currentGPUAlias))"/>
                            <xsl:variable name="AdapterName" select="concat($currentGPUAlias, ': ', $currentGPUName)"/>
                            <xsl:variable name="currentGPUBDF" select="exsl:get_adapter_bdf_by_alias(string($currentGPUAlias))" />
                            <section type="tree" expanded="true" valueAlign="left">
                              <header displayName="{$AdapterName}" />
                              <xsl:if test="$currentGPUBDF != ''">
                                <tree valueAlign="left">
                                  <columns>
                                    <column>
                                      <xsl:text>/GPU</xsl:text>
                                      <xsl:value-of select="$currentGPUBDF"/>
                                      <xsl:choose>
                                        <xsl:when test="not(exsl:ctx('gpuMetricsSelected', '') = '')">
                                          <xsl:text>AdapterInfo</xsl:text>
                                        </xsl:when>
                                        <xsl:otherwise>
                                          <xsl:text>AdapterInfoNonHWMetric</xsl:text>
                                        </xsl:otherwise>
                                      </xsl:choose>
                                    </column>
                                  </columns>
                                </tree>
                              </xsl:if>
                              <xsl:if test="exsl:ctx(concat('gpu', $currentGPUBDF, 'OpenClOpenClVersion'), ' ')!= ' '">
                                <sections>
                                  <section type="tree" expanded="true" valueAlign="left">
                                    <header displayName="%GPUOpenCLInfo" />
                                    <tree valueAlign="left">
                                      <columns>
                                        <column>
                                          <xsl:text>/GPU</xsl:text>
                                          <xsl:value-of select="$currentGPUBDF"/>
                                          <xsl:text>OpenCLInfo</xsl:text>
                                        </column>
                                      </columns>
                                    </tree>
                                  </section>
                                </sections>
                              </xsl:if>
                            </section>
                          </xsl:for-each>
                        </sections>
                      </section>
                    </xsl:when>
                    <xsl:otherwise>
                      <section type="tree" expanded="true" valueAlign="left">
                        <header displayName="%GPU" />
                        <tree valueAlign="left">
                          <columns>
                            <column>/GPUAdapterInfo</column>
                          </columns>
                        </tree>
                        <xsl:if test="exsl:ctx('gpuOpenClOpenClVersion')!=' '">
                          <sections>
                            <section type="tree" expanded="true" valueAlign="left">
                              <header displayName="%GPUOpenCLInfo" />
                              <tree valueAlign="left">
                                <columns>
                                  <column>/GPUOpenCLInfo</column>
                                </columns>
                              </tree>
                            </section>
                          </sections>
                        </xsl:if>
                      </section>
                    </xsl:otherwise>
                  </xsl:choose>
                </xsl:if>
              </sections>
            </section>
		      </xsl:if>
        </sections>
        <xsl:copy-of select="$summaryBlocks//root/messages"/>
      </config>
    </html>
  </xsl:template>
</xsl:stylesheet>
