/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.tooling.internal.provider.continuous;

import java.io.InputStream;
import java.util.concurrent.ExecutorService;
import java.util.function.Supplier;
import org.gradle.api.logging.LogLevel;
import org.gradle.deployment.internal.ContinuousExecutionGate;
import org.gradle.deployment.internal.DefaultContinuousExecutionGate;
import org.gradle.deployment.internal.Deployment;
import org.gradle.deployment.internal.DeploymentInternal;
import org.gradle.deployment.internal.DeploymentRegistryInternal;
import org.gradle.deployment.internal.PendingChangesListener;
import org.gradle.execution.CancellableOperationManager;
import org.gradle.execution.DefaultCancellableOperationManager;
import org.gradle.execution.PassThruCancellableOperationManager;
import org.gradle.initialization.BuildCancellationToken;
import org.gradle.initialization.BuildRequestMetaData;
import org.gradle.internal.buildevents.BuildStartedTime;
import org.gradle.internal.buildtree.BuildActionRunner;
import org.gradle.internal.concurrent.ExecutorFactory;
import org.gradle.internal.event.ListenerManager;
import org.gradle.internal.execution.WorkInputListener;
import org.gradle.internal.execution.WorkInputListeners;
import org.gradle.internal.file.Stat;
import org.gradle.internal.invocation.BuildAction;
import org.gradle.internal.logging.text.StyledTextOutput;
import org.gradle.internal.logging.text.StyledTextOutputFactory;
import org.gradle.internal.os.OperatingSystem;
import org.gradle.internal.session.BuildSessionActionExecutor;
import org.gradle.internal.session.BuildSessionContext;
import org.gradle.internal.snapshot.CaseSensitivity;
import org.gradle.internal.time.Clock;
import org.gradle.internal.watch.vfs.BuildLifecycleAwareVirtualFileSystem;
import org.gradle.internal.watch.vfs.FileChangeListener;
import org.gradle.internal.watch.vfs.FileChangeListeners;
import org.gradle.tooling.internal.provider.continuous.AccumulateBuildInputsListener;
import org.gradle.tooling.internal.provider.continuous.BuildInputHierarchy;
import org.gradle.tooling.internal.provider.continuous.ContinuousBuildTriggerHandler;
import org.gradle.tooling.internal.provider.continuous.FileEventCollector;
import org.gradle.tooling.internal.provider.continuous.SingleFirePendingChangesListener;
import org.gradle.util.internal.DisconnectableInputStream;

public class ContinuousBuildActionExecutor
implements BuildSessionActionExecutor {
    private final BuildSessionActionExecutor delegate;
    private final WorkInputListeners inputsListeners;
    private final FileChangeListeners fileChangeListeners;
    private final BuildRequestMetaData requestMetaData;
    private final OperatingSystem operatingSystem;
    private final BuildCancellationToken cancellationToken;
    private final DeploymentRegistryInternal deploymentRegistry;
    private final ListenerManager listenerManager;
    private final BuildStartedTime buildStartedTime;
    private final Clock clock;
    private final Stat stat;
    private final CaseSensitivity caseSensitivity;
    private final BuildLifecycleAwareVirtualFileSystem virtualFileSystem;
    private final ExecutorFactory executorFactory;
    private final StyledTextOutput logger;

    public ContinuousBuildActionExecutor(WorkInputListeners inputListeners, FileChangeListeners fileChangeListeners, StyledTextOutputFactory styledTextOutputFactory, ExecutorFactory executorFactory, BuildRequestMetaData requestMetaData, BuildCancellationToken cancellationToken, DeploymentRegistryInternal deploymentRegistry, ListenerManager listenerManager, BuildStartedTime buildStartedTime, Clock clock, Stat stat, CaseSensitivity caseSensitivity, BuildLifecycleAwareVirtualFileSystem virtualFileSystem, BuildSessionActionExecutor delegate) {
        this.inputsListeners = inputListeners;
        this.fileChangeListeners = fileChangeListeners;
        this.requestMetaData = requestMetaData;
        this.cancellationToken = cancellationToken;
        this.deploymentRegistry = deploymentRegistry;
        this.listenerManager = listenerManager;
        this.buildStartedTime = buildStartedTime;
        this.clock = clock;
        this.stat = stat;
        this.caseSensitivity = caseSensitivity;
        this.virtualFileSystem = virtualFileSystem;
        this.operatingSystem = OperatingSystem.current();
        this.executorFactory = executorFactory;
        this.logger = styledTextOutputFactory.create(ContinuousBuildActionExecutor.class, LogLevel.QUIET);
        this.delegate = delegate;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public BuildActionRunner.Result execute(BuildAction action, BuildSessionContext buildSession) {
        if (action.getStartParameter().isContinuous()) {
            DefaultContinuousExecutionGate alwaysOpenExecutionGate = new DefaultContinuousExecutionGate();
            CancellableOperationManager cancellableOperationManager = this.createCancellableOperationManager(this.requestMetaData, this.cancellationToken);
            return this.executeMultipleBuilds(action, this.requestMetaData, buildSession, this.cancellationToken, cancellableOperationManager, (ContinuousExecutionGate)alwaysOpenExecutionGate);
        }
        try {
            BuildActionRunner.Result result = this.delegate.execute(action, buildSession);
            return result;
        }
        finally {
            CancellableOperationManager cancellableOperationManager = this.createCancellableOperationManager(this.requestMetaData, this.cancellationToken);
            this.waitForDeployments(action, this.requestMetaData, buildSession, this.cancellationToken, cancellableOperationManager);
        }
    }

    private CancellableOperationManager createCancellableOperationManager(BuildRequestMetaData requestContext, BuildCancellationToken cancellationToken) {
        PassThruCancellableOperationManager cancellableOperationManager;
        if (requestContext.isInteractive()) {
            if (!(System.in instanceof DisconnectableInputStream)) {
                System.setIn((InputStream)new DisconnectableInputStream(System.in));
            }
            DisconnectableInputStream inputStream = (DisconnectableInputStream)System.in;
            cancellableOperationManager = new DefaultCancellableOperationManager((ExecutorService)this.executorFactory.create("Cancel signal monitor"), inputStream, cancellationToken);
        } else {
            cancellableOperationManager = new PassThruCancellableOperationManager(cancellationToken);
        }
        return cancellableOperationManager;
    }

    private void waitForDeployments(BuildAction action, BuildRequestMetaData requestContext, BuildSessionContext buildSession, BuildCancellationToken cancellationToken, CancellableOperationManager cancellableOperationManager) {
        if (!this.deploymentRegistry.getRunningDeployments().isEmpty()) {
            for (Deployment deployment : this.deploymentRegistry.getRunningDeployments()) {
                ((DeploymentInternal)deployment).outOfDate();
            }
            this.logger.println().println((Object)"Reloadable deployment detected. Entering continuous build.");
            this.resetBuildStartedTime();
            ContinuousExecutionGate deploymentRequestExecutionGate = this.deploymentRegistry.getExecutionGate();
            this.executeMultipleBuilds(action, requestContext, buildSession, cancellationToken, cancellableOperationManager, deploymentRequestExecutionGate);
        }
        cancellableOperationManager.closeInput();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private BuildActionRunner.Result executeMultipleBuilds(BuildAction action, BuildRequestMetaData requestContext, BuildSessionContext buildSession, BuildCancellationToken cancellationToken, CancellableOperationManager cancellableOperationManager, ContinuousExecutionGate continuousExecutionGate) {
        BuildActionRunner.Result lastResult;
        PendingChangesListener pendingChangesListener = (PendingChangesListener)this.listenerManager.getBroadcaster(PendingChangesListener.class);
        while (true) {
            BuildInputHierarchy buildInputs = new BuildInputHierarchy(this.caseSensitivity, this.stat);
            ContinuousBuildTriggerHandler continuousBuildTriggerHandler = new ContinuousBuildTriggerHandler(cancellationToken, continuousExecutionGate, action.getStartParameter().getContinuousBuildQuietPeriod());
            SingleFirePendingChangesListener singleFirePendingChangesListener = new SingleFirePendingChangesListener(pendingChangesListener);
            FileEventCollector fileEventCollector = new FileEventCollector(buildInputs, () -> {
                continuousBuildTriggerHandler.notifyFileChangeArrived();
                singleFirePendingChangesListener.onPendingChanges();
            });
            try {
                this.fileChangeListeners.addListener((FileChangeListener)fileEventCollector);
                lastResult = this.executeBuildAndAccumulateInputs(action, new AccumulateBuildInputsListener(buildInputs), buildSession);
                this.virtualFileSystem.afterBuildFinished();
                if (buildInputs.isEmpty()) {
                    this.logger.println().withStyle(StyledTextOutput.Style.Failure).println((Object)"Exiting continuous build as Gradle did not detect any file system inputs.");
                    BuildActionRunner.Result result = lastResult;
                    return result;
                }
                if (!continuousBuildTriggerHandler.hasBeenTriggered() && !this.virtualFileSystem.isWatchingAnyLocations()) {
                    this.logger.println().withStyle(StyledTextOutput.Style.Failure).println((Object)"Exiting continuous build as Gradle does not watch any file system locations.");
                    BuildActionRunner.Result result = lastResult;
                    return result;
                }
                cancellableOperationManager.monitorInput(operationToken -> {
                    continuousBuildTriggerHandler.wait(() -> this.logger.println().println((Object)("Waiting for changes to input files..." + this.determineExitHint(requestContext))));
                    if (!operationToken.isCancellationRequested()) {
                        fileEventCollector.reportChanges(this.logger);
                    }
                });
            }
            finally {
                this.fileChangeListeners.removeListener((FileChangeListener)fileEventCollector);
            }
            if (cancellationToken.isCancellationRequested()) break;
            this.logger.println((Object)"Change detected, executing build...").println();
            this.resetBuildStartedTime();
        }
        this.logger.println((Object)"Build cancelled.");
        return lastResult;
    }

    private void resetBuildStartedTime() {
        this.buildStartedTime.reset(this.clock.getCurrentTime());
    }

    private String determineExitHint(BuildRequestMetaData requestContext) {
        if (requestContext.isInteractive()) {
            if (this.operatingSystem.isWindows()) {
                return " (ctrl-d then enter to exit)";
            }
            return " (ctrl-d to exit)";
        }
        return "";
    }

    private BuildActionRunner.Result executeBuildAndAccumulateInputs(BuildAction action, WorkInputListener inputListener, BuildSessionContext buildSession) {
        return this.withInputListener(inputListener, () -> this.delegate.execute(action, buildSession));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private <T> T withInputListener(WorkInputListener listener, Supplier<T> supplier) {
        try {
            this.inputsListeners.addListener(listener);
            T t = supplier.get();
            return t;
        }
        finally {
            this.inputsListeners.removeListener(listener);
        }
    }
}

